<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_117.xsd" xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
  <xsl:template match="ns1:SENT_117">
    <!-- TODO: Auto-generated template -->
    <html>
      <head>
        <script>
          //<![CDATA[
					// Module
				var languative;
				(function (languative) {
				    var phraseIdAttr = "data-phrase-id";

				    languative.ignoreTags = {
				        img: "<img />",
				        br: "<br />",
				        hr: "<hr />"
				    };

				    languative.dictonaries = {
				        html: {
				            _id: "en",
				            _name: "English"
				        },

				        pl: {
				            _id: "pl",
				            _name: "Polski - Polish"
				        },

				        en: {
				            _id: "en",
				            _name: "English"
				        }
				    };

				    languative.selectedDictionary = null;

				    function getDictionary(langKey) {
				        langKey = langKey.toLowerCase();
				        if (langKey in languative.dictonaries)
				            return languative.dictonaries[langKey];
				            else
				            return languative.dictonaries["pl"];

				        // Dictionary at key "pl-PL" not found, so keep looking for key "pl"
				        var sep = langKey.indexOf("-");
				        if (sep > 0)
				            langKey = langKey.substring(0, sep);
				        return languative.dictonaries[langKey];
				    }
				    languative.getDictionary = getDictionary;

				    function getPhrase(phraseId) {
				        var res = findPhrase(phraseId);
				        if (res)
				            return res; else
				            return phraseId;
				    }
				    languative.getPhrase = getPhrase;

				    function findPhrase(phraseId) {
				        if ((phraseId == null) || (phraseId == ""))
				            return null;

				        if ((languative.selectedDictionary != null) && (phraseId in languative.selectedDictionary))
				            return languative.selectedDictionary[phraseId];
				        if (phraseId in languative.dictonaries.html)
				            return languative.dictonaries.html[phraseId];

				        return null;
				    }
				    languative.findPhrase = findPhrase;

				    function getYesNo(value) {
				        if (value === undefined)
				            return getPhrase("undefined"); else if (value)
				            return getPhrase("yes"); else
				            return getPhrase("no");
				    }
				    languative.getYesNo = getYesNo;

				    //IE8 Tweak
				    function getAttr(node, attr) {
				        var result = (node.getAttribute && node.getAttribute(attr)) || null;
				        if (!result && node.attributes) {
				            for (var i = 0; i < node.attributes.length; i++) {
				                var attrNode = node.attributes[i];
				                if (attrNode.nodeName === attr)
				                    return attrNode.nodeValue;
				            }
				        }
				        return result;
				    }

				    function changeLanguage(langKey) {
				        function setTagPhrase(tag, phrase) {
				            if (tag.childNodes.length > 1) {
				                for (var ci = 0; ci < tag.childNodes.length; ci++) {
				                    var chNode = tag.childNodes[ci];
				                    var nName = chNode.nodeName.toLowerCase();
				                    if (!(nName in languative.ignoreTags)) {
				                        if ("innerHTML" in chNode) {
				                            chNode["innerHTML"] = " " + phrase[ci] + " ";
				                        } else {
				                            chNode.nodeValue = " " + phrase[ci] + " ";
				                        }
				                    }
				                }
				            } else {
				                tag.innerHTML = " " + phrase + " ";
				            }
				        }

				        //return;
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            console.warn("Cannot identify dictionary by key '" + langKey + "'. Default dictionary (" + languative.dictonaries.html._id + ": " + languative.dictonaries.html._name + ") used instead.");
				            langDict = languative.dictonaries.html;
				        }
				        languative.selectedDictionary = langDict;

				        var tags = getHtmlTags();
				        for (var ti = 0; ti < tags.length; ti++) {
				            var tag = tags[ti];
				            var phraseId = getAttr(tag, phraseIdAttr);
				            if ((phraseId != null)) {
				                var phraseValue = languative.getPhrase(phraseId);
				                if (phraseValue) {
				                    setTagPhrase(tag, phraseValue);
				                } else {
				                    console.warn("Phrase not definied in dictionary: data-phrase-id='" + phraseId + "'");
				                }
				            }
				        }

				        if (langDict["Title"] != null) {
				            document.title = langDict["Title"];
				        }
				    }
				    languative.changeLanguage = changeLanguage;

				    function getHtmlTags() {
				        var res = new Array();
				        var docTags = document.body.getElementsByTagName("*");

				        for (var i = 0; i < docTags.length; i++) {
				            var docTag = docTags[i];
				            var phraseId = getAttr(docTag, phraseIdAttr);
				            if (phraseId)
				                res.push(docTag);
				        }
				        return res;
				    }

				    var initialized = false;

				    function init() {
				        if (!initialized) {
				            initialized = true;
				            var htmlDict = languative.dictonaries.en;

				            for (var dictKey in htmlDict) {
				                if (!(dictKey in languative.dictonaries.html)) {
				                    languative.dictonaries.html[dictKey] = htmlDict[dictKey];
				                }
				            }
				            var nav = window.navigator;
				            languative.changeLanguage(nav.userLanguage || nav.language);
				        }
				    }
				    languative.init = init;

				    function modifyDictionary(langKey, dictModifications) {
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            languative.dictonaries[langKey.toLowerCase()] = dictModifications;
				        } else {
				            for (var dictKey in dictModifications) {
				                langDict[dictKey] = dictModifications[dictKey];
				            }
				        }
				    }
				    languative.modifyDictionary = modifyDictionary;
				})(languative || (languative = {}));

				if (document.addEventListener)
				    document.addEventListener('DOMContentLoaded', languative.init);

				if (window.addEventListener) {
				    window.addEventListener('load', languative.init, false);
				} else {
				    window.attachEvent('onload', languative.init);
				}
				<!-- sourceMappingURL=languative.js.map -->

				languative.modifyDictionary("html", {
            		githubLink: "Fork me on GitHub"
        		});
languative.modifyDictionary("pl", {
sent117: "SENT117 - POTWIERDZENIE REJESTRACJI ZGŁOSZENIA PRZEWOZU PRODUKTÓW LECZNICZYCH OBJĘTYCH ZAKAZEM WYWOZU ROZPOCZYNAJĄCEGO SIĘ NA TERYTORIUM POLSKI I NADANIE NUMERU REFERENCYJNEGO - PODMIOT WYSYŁAJĄCY (TRANSPORT DROGOWY I KOLEJOWY)",
selectLanguage: "Wybierz język:",
english: "English",
polish: "Polski",
sentNumber: "NUMER REFERENCYJNY ZGŁOSZENIA:",
sentMultipleNumber: "NUMER REFERENCYJNY ZGŁOSZENIA ZBIORCZEGO:",
sentPlannedControlInfo: "Informacja o planowanej kontroli przewozu",
sentPlannedControlInfoClose: "Informacja o kontroli przewozu",
sentPlaceOfControl: "Miejsce kontroli:",
sentPlaceOfControl1: "Kontrola w miejscu dostarczenia towaru",
sentPlaceOfControl2: "Kontrola w miejscu wskazanym",
sentPlannedControlInfoCancel: "Informacja o anulowaniu wezwania",
sentKeyNumber: "Klucze autoryzacyjne przypisane do zgłoszenia",
sentSenderKey: "Klucz podmiotu wysyłającego:",
sentRecipientKey: "Klucz podmiotu odbierającego:",
sentCarrierKey: "Klucz przewoźnika:",
sentInformationData: "Dane informacyjne o zgłoszeniu",
sentDateOfRegistration: "Data rejestracji:",
sentCreatedUser: "Użytkownik rejestrujący zgłoszenie:",
sentModificationDate: "Data modyfikacji:",
sentModifierUser: "Użytkownik modyfikujący zgłoszenie:",
sentSourceDocumentID: "Numer własny zgłoszenia:",
sentChecksumOfSourceDoc: "Suma kontrolna:",
sentIdSent: "SENT ID:",
sentStatus: "Status zgłoszenia:",
sentSentStatus0: "Zarejestrowane",
sentSentStatus1: "Niekompletne",
sentSentStatus2: "Kompletne",
sentSentStatus3: "Zamknięte",
sentSentStatus4: "Anulowane",
sentSentStatus5: "Zamknięte automatycznie",
sentTypeOfTransport: "Rodzaj transportu:",
sentTypeOfTransport1: "Drogowy",
sentTypeOfTransport2: "Kolejowy",
sentGoodsSenderInfo: "Informacje o podmiocie wysyłającym towar",
sentBasicInfo: "Informacje podstawowe",
sentIdSisc: "Identyfikator idSISC:",
sentTraderName: "Pełna nazwa:",
sentTraderIdentityType: "Rodzaj identyfikatora:",
sentTraderIdentityNumber: "Numer identyfikatora:",
sentAdress: "Informacje adresowe",
sentGoodsRecipientInfo: "Informacje o podmiocie odbierającym lub odbiorcy towaru",
sentGoodsInfo: "Informacja o przewozie towaru",
sentPlaceOfLoading: "Miejsce załadunku towaru",
sentTercId: "Identyfikator terytorialny:",
sentSimcId: "Identyfikator miejscowości:",
sentUlicId: "Identyfikator ulic:",
sentLatitude: "Szerokość geograficzna:",
sentLongitude: "Długość geograficzna:",
sentPlannedStartCarriageDate: "Planowana data rozpoczęcia przewozu:",
sentCarriedGoodsInfo: "Informacje o przewożonych towarach",
sentSingleElementNumber: "Lp.",
sentCodeEan: "Kod EAN",
sentGoodsName: "Nazwa towaru",
sentAmountOfGoods: "Ilość",
sentUnitOfMeasure: "Jednostka miary",
sentMedicinalNumberOfPermit: "Numer zezwolenia",
sentMedicinalNumberOfPermitAuthority: "Organ wydający",
sentAdditionalInfo: "Informacje dodatkowe",
sentProvince: "Województwo:",
sentComments: "Uwagi do zgłoszenia:"
});

languative.modifyDictionary("en", {
sent117: "SENT117 - CONFIRMATION OF THE NOTIFICATION OF THE CARRIAGE OF MEDICAL PRODUCTS COVERED BY THE EXPORT PROHIBITION STARTING IN THE TERRITORY OF POLAND AND ASSIGNING THE REFERENCE NUMBER - THE CONSIGNOR (ROAD AND RAILWAY TRANSPORT)",
selectLanguage: "Select language:",
english: "English",
polish: "Polski",
sentNumber: "CARRIAGE NOTIFICATION NUMBER:",
sentMultipleNumber: "CUMULATIVE CARRIAGE NOTIFICATION NUMBER:",
sentPlannedControlInfo: "Information about planned carriage control",
sentPlannedControlInfoClose: "Information about carriage control",
sentPlaceOfControl: "Place of control:",
sentPlaceOfControl1: "Control at the place of goods delivery",
sentPlaceOfControl2: "Control at the indicated place",
sentPlannedControlInfoCancel: "Information about cancelation the summons",
sentKeyNumber: "Authorisation keys assigned to the notification",
sentSenderKey: "Key of the consignor:",
sentRecipientKey: "Key of the consignee:",
sentCarrierKey: "Key of the carrier:",
sentInformationData: "Information data on the notification",
sentDateOfRegistration: "Registration date:",
sentCreatedUser: "Registered by:",
sentModificationDate: "Modification date:",
sentModifierUser: "Modifying user:",
sentSourceDocumentID: "Own number of the notification:",
sentChecksumOfSourceDoc: "Checksum:",
sentIdSent: "SENT ID:",
sentStatus: "Status of SENT notification:",
sentSentStatus0: "Registered",
sentSentStatus1: "Incomplete",
sentSentStatus2: "Complete",
sentSentStatus3: "Closed",
sentSentStatus4: "Canceled",
sentSentStatus5: "Automatically closed",
sentTypeOfTransport: "Type of transport:",
sentTypeOfTransport1: "Road",
sentTypeOfTransport2: "Railway",
sentGoodsSenderInfo: "Information on the consignor",
sentBasicInfo: "Basic information",
sentIdSisc: "idSISC identification number:",
sentTraderName: "Full name:",
sentTraderIdentityType: "Identification type:",
sentTraderIdentityNumber: "Identification number:",
sentAdress: "Address information",
sentGoodsRecipientInfo: "Information on the consignee or the recipient of the goods",
sentGoodsInfo: "Information on the goods carriage",
sentPlaceOfLoading: "Place of goods loading",
sentTercId: "Identifier of territorial division:",
sentSimcId: "City identifier of territorial division:",
sentUlicId: "Street identifier of territorial division:",
sentLatitude: "Latitude:",
sentLongitude: "Longitude:",
sentPlannedStartCarriageDate: "Planned start date of the carriage:",
sentCarriedGoodsInfo: "Information on transported goods",
sentSingleElementNumber: "No",
sentCodeEan: "EAN Code",
sentGoodsName: "Name of the goods",
sentAmountOfGoods: "Quantity",
sentUnitOfMeasure: "Unit of measure",
sentMedicinalNumberOfPermit: "Number of permit",
sentMedicinalNumberOfPermitAuthority: "Issuing authority ",
sentAdditionalInfo: "Additional information",
sentProvince: "Province:",
sentComments: "Comments to the notification:"
});

function loadHtmlDictionary() {
document.getElementById("htmlDictionary").innerText = JSON.stringify(languative.dictonaries.html, null, "  ");
}

function loadActiveDictionary() {
document.getElementById("activeDictionary").innerText = JSON.stringify(languative.getDictionaryFromHtml(), null, "  ");
}


//]]>
        </script>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {-webkit-print-color-adjust: exact;}
          }

          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }

          .sent-xslt {
          border-collapse: initial;
          }

          .sent-xslt h1 {
          padding: 6px 4px 4px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#c5c2c2;
          font-weight: normal;
          font-size: 12px;
          margin-bottom: 0;
          border-bottom: 1px solid #c8c9ca;
          }

          .sent-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }

          .sent-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }

          .sent-xslt .t2 {
          padding: 15px 5px 3px 5px;
          border: 1px solid;
          margin: 0 10px 20px 10px;
          }

          .sent-xslt .t3 {
          padding: 15px 5px 3px 5px;
          border: 1px solid red;
          margin: 0 10px 20px 10px;
          }

          .sent-xslt .grupName {
          font-size: 12px;
          margin: 0 !important;
          font-weight: bold;
          display:block;
          color: #000000;
          background-color:#dbddde;
          padding:5px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .grupNameRed {
          font-size: 14px;
          margin: -15px -5px 0 -5px;
          font-weight: bold;
          display:block;
          color: #000000;
          background-color:red;
          padding:5px 5px 5px 10px;
          border: 1px solid red;
          }

          .sent-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .sent-xslt .element-2 {
          font-size: 14px;
          font-weight: normal;
          color: #008540;
          }

          .sent-xslt .green {
          background-color: #DAFFCC;
          height: 35px;
          padding-top: 4px;
          }

          .sent-xslt .green-key {
          background-color: #DAFFCC;
          padding: 7px 0px !important;
          }

          .sent-xslt .element-3 {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          font-size: 12px;
          font-weight: normal;
          border-spacing: 10 10;
          white-space: pre-wrap; /* Since CSS 2.1 */
          white-space: -moz-pre-wrap; /* Mozilla, since 1999 */
          white-space: -pre-wrap; /* Opera 4-6 */
          white-space: -o-pre-wrap; /* Opera 7 */
          word-wrap: break-word; /* Internet Explorer 5.5+ */
          word-break: normal;
          }
          
          .sent-xslt .grupInfo p {
          margin: 1px 0 1px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .sent-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .grupInfoSent {
          min-height: 40px;
          }

          .sent-xslt .grupInfoSent p {
          margin: -2px 0 1px 10px;
          font-size: 16px;
          font-weight: bold;
          }

          .sent-xslt .oilstatus {
          margin: 0 5px 0 -5px;
          margin: 2px 0 1px 10px;
          font-size: 14px;
          padding-bottom: 12px;
          color: red;
          }

          .sent-xslt .info {
          width: 100%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .sent-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .sent-xslt .info3 {
          width: 33%;
          float: left;
          display: table-cell;
          }

          .sent-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }

          .sent-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }

          .sent-xslt .table {
          display: table;
          width: 99%;
          margin: 4px 0 15px 7px;
          border-spacing: 0 0;
          border-top: 1px solid #999999;
          border-left: 1px solid #999999;
          }

          .sent-xslt .table-header {
          font-size: 10px;
          font-weight: bold;
          padding: 5px;
          background-color: #ececec;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element {
          font-size: 12px;
          font-weight: normal;
          padding: 2px 5px;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element2 {
          font-size: 12px;
          font-weight: normal;
          padding: 0;
          }

          .sent-xslt .table-element3 {
          font-size: 12px;
          font-weight: bold;
          border: 1px #999999;
          border-top-style: solid;
          margin: 0;
          }

          .sent-xslt .table-element p {
          margin-left: 0;
          }

          .sent-xslt .table-element2 p {
          margin-left: 0;
          }

          .sent-xslt .table-element3 p {
          margin-left: 0;
          padding: 0px 5px;
          }

        </style>

      </head>
      <body>
        <div class="sent-xslt">
          <section class="sent-xslt s1">
            <div class="sent-xslt lang">
              <ul>
                <li>
                  <span class="sent-xslt element-1" data-phrase-id="selectLanguage"></span>
                </li>
                <li>
                  <span class="sent-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('en'); translateStatusPl();">
                      <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAB6ElEQVQoz2OYNHPfjqtvqqcfS2kGosOJjQdu3n27NrlxTUIdkOGZvc0jbYdtzIaoxp1zAvOr5x5lWLLi1P+Nq/79+3/74ZdFG27PX38HyP4/ped/XyuQMWnh5d65F06eePyvq+bf358TNl1gSGo5uOfku/9Ll/8/uPf///9t064Cyf+pmf8TEoF0Sd+lL4vWfO/uBrLnrbokaTIDpGHhhrt1E68+3Hf/T1P9fwiIifkfHgFi5Gb+f/Hiwp23jp7Li5qOCOpOZAA6FOQGNBAa+t/PD00MqOzMtZcMaxJr/0/u+J+S8j8+/n9k5P+QEJBSH59/rq6/7O1/Wlp+NzH5qqf3VVv7Z7Bbq7wVDhtsbf+YWUDMBeK/f//++fvn958/J6++YLCP29Qz53xU2o4rV9//f/vmZ3I8SJWRyW99Q7CGv0+dHPfP3CohPSskYT2DcDaDedi6xetBIfO5se5DV1dMyTEg+4+27i9NbaCrreyX/Pz//8usuS8SYpqmnmMQTGeYvPnyv39/v7dXHD1wu7DhYF7DYaAL/4Z4/A5y/vf3b3jattC41dsP3/r758frBN/soiUMVfMOTHFJds5cJKgzh0djMofqhPPXXrRKW7SIm5y+8pJBvJhBtIBBOFfEsK53z3VX0zwAPExoqi63l4YAAAAASUVORK5CYII='/>
                    </a>
                  </span>
                </li>
                <li>
                  <span class="sent-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('pl'); translateStatusEn();">
                      <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAhFBMVEXDAADKAADVAQHX19faAADd3d3jDQ3k5eXlExPmGRnnLi7oHx/oMjLoNjbpJCTqKirq6urrLi7sLy/sOzrsRETtNDTtS0vuUFDu7u7vi4vvmZnwVlfwj4/xlJTy8vL0m5v19fX29vb39/f4+Pj5+fn6+vr7+/v8/Pz9/f39/f7+/v7///9BfFeGAAAAXUlEQVQIHQXB0W1CMRRAMecRpI7BZ/dfiRWQqBC5p/Z6wPDhz5t1+xWVqp4bq1FVLRuWqioucKuqNPu8AKNjtb3AdU5nuncB1zmdSTa4vtOZxrT94Hsf+TQstkEQ/8uqTs/uhVeSAAAAAElFTkSuQmCC'/>
                    </a>
                  </span>
                </li>
              </ul>
            </div>
            <h1 data-phrase-id="sent117"></h1>
            <div class="sent-xslt t1">
              <div class="sent-xslt grupInfoSent">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1 sent" data-phrase-id="sentNumber"></span>
                    <br/>
                    <xsl:value-of select="ns1:SentNumber"/>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <xsl:if test="ns1:RegisteredSentInfo/tp:MultipleSentNumber != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentMultipleNumber"></span>
                      <br/>
                      <xsl:value-of select="ns1:RegisteredSentInfo/tp:MultipleSentNumber"/>
                    </p>
                  </xsl:if>
                </div>
              </div>
            </div>
            <xsl:if test="ns1:InformationAboutControl/tp:PlaceOfControl != ''">
              <xsl:choose>
                <xsl:when test="ns1:RegisteredSentInfo/tp:SentStatus = '3' or ns1:RegisteredSentInfo/tp:SentStatus = '5'">
                  <div class="sent-xslt t2" id="sentInformationAboutControl">
                    <p class="sent-xslt grupName" data-phrase-id="sentPlannedControlInfoClose"></p>
                    <div class="sent-xslt grupInfo">
                      <pre>
                        <span class="sent-xslt element-3">
                          <xsl:value-of select="ns1:InformationAboutControl/tp:RecommendationsForControl"/>
                        </span>
                      </pre>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentPlaceOfControl"></span>
                        <xsl:choose>
                          <xsl:when test="ns1:InformationAboutControl/tp:PlaceOfControl = '1'">
                            <span data-phrase-id="sentPlaceOfControl1"></span>
                          </xsl:when>
                          <xsl:when test="ns1:InformationAboutControl/tp:PlaceOfControl = '2'">
                            <span data-phrase-id="sentPlaceOfControl2"></span>
                          </xsl:when>
                        </xsl:choose>
                      </p>
                    </div>
                  </div>
                </xsl:when>
                <xsl:when test="ns1:RegisteredSentInfo/tp:SentStatus = '4'">
                  <div class="sent-xslt t2" id="sentInformationAboutControl">
                    <p class="sent-xslt grupName" data-phrase-id="sentPlannedControlInfoCancel"></p>
                    <div class="sent-xslt grupInfo">
                      <pre>
                        <span class="sent-xslt element-3">
                          <xsl:value-of select="ns1:InformationAboutControl/tp:RecommendationsForControl"/>
                        </span>
                      </pre>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentPlaceOfControl"></span>
                        <xsl:choose>
                          <xsl:when test="ns1:InformationAboutControl/tp:PlaceOfControl = '1'">
                            <span data-phrase-id="sentPlaceOfControl1"></span>
                          </xsl:when>
                          <xsl:when test="ns1:InformationAboutControl/tp:PlaceOfControl = '2'">
                            <span data-phrase-id="sentPlaceOfControl2"></span>
                          </xsl:when>
                        </xsl:choose>
                      </p>
                    </div>
                  </div>
                </xsl:when>
                <xsl:otherwise>
                  <div class="sent-xslt t3" id="sentInformationAboutControl">
                    <p class="sent-xslt grupNameRed" data-phrase-id="sentPlannedControlInfo"></p>
                    <div class="sent-xslt grupInfo">
                      <pre>
                        <span class="sent-xslt element-3">
                          <xsl:value-of select="ns1:InformationAboutControl/tp:RecommendationsForControl"/>
                        </span>
                      </pre>
                      <p>
                        <span class="sent-xslt element-1" data-phrase-id="sentPlaceOfControl"></span>
                        <xsl:choose>
                          <xsl:when test="ns1:InformationAboutControl/tp:PlaceOfControl = '1'">
                            <span data-phrase-id="sentPlaceOfControl1"></span>
                          </xsl:when>
                          <xsl:when test="ns1:InformationAboutControl/tp:PlaceOfControl = '2'">
                            <span data-phrase-id="sentPlaceOfControl2"></span>
                          </xsl:when>
                        </xsl:choose>
                      </p>
                    </div>
                  </div>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentKeyNumber"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt green">
                  <div class="sent-xslt info3">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentSenderKey"></span>
                      <xsl:value-of select="ns1:KeyNumber/tp:SenderKey"/>
                    </p>
                  </div>
                  <div class="sent-xslt info3">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentRecipientKey"></span>
                      <xsl:value-of select="ns1:KeyNumber/tp:RecipientKey"/>
                    </p>
                  </div>
                  <div class="sent-xslt info3">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentCarrierKey"></span>
                      <xsl:value-of select="ns1:KeyNumber/tp:CarrierKey"/>
                    </p>
                  </div>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentInformationData"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <xsl:variable name="creDate" select="substring-before(ns1:RegisteredSentInfo/tp:CreationDate, 'T')"/>
                  <xsl:variable name="creTime" select="substring(ns1:RegisteredSentInfo/tp:CreationDate, 12,8)"/>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentDateOfRegistration"></span>
                    <xsl:value-of select="$creDate"/> godz.<xsl:value-of select="$creTime"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentCreatedUser"></span>
                    <xsl:value-of select="ns1:RegisteredSentInfo/tp:Creator"/>
                  </p>
                  <xsl:variable name="modDate" select="substring-before(ns1:RegisteredSentInfo/tp:ModificationDate, 'T')"/>
                  <xsl:variable name="modTime" select="substring(ns1:RegisteredSentInfo/tp:ModificationDate, 12,8)"/>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentModificationDate"></span>
                    <xsl:value-of select="$modDate"/> godz.<xsl:value-of select="$modTime"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentModifierUser"></span>
                    <xsl:value-of select="ns1:RegisteredSentInfo/tp:Modifier"/>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <xsl:if test="ns1:RegisteredSentInfo/tp:SourceDocumentId !=''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentSourceDocumentID"></span>
                      <xsl:value-of select="ns1:RegisteredSentInfo/tp:SourceDocumentId"/>
                    </p>
                  </xsl:if>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentChecksumOfSourceDoc"></span>
                    <xsl:value-of select="ns1:RegisteredSentInfo/tp:ChecksumOfSourceDocument"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentIdSent"></span>
                    <xsl:value-of select="ns1:RegisteredSentInfo/tp:SentId"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentStatus"></span>
                    <xsl:choose>
                      <xsl:when test="ns1:RegisteredSentInfo/tp:SentStatus = '0'">
                        <span data-phrase-id="sentSentStatus0"></span>
                      </xsl:when>
                      <xsl:when test="ns1:RegisteredSentInfo/tp:SentStatus = '1'">
                        <span data-phrase-id="sentSentStatus1"></span>
                      </xsl:when>
                      <xsl:when test="ns1:RegisteredSentInfo/tp:SentStatus = '2'">
                        <span data-phrase-id="sentSentStatus2"></span>
                      </xsl:when>
                      <xsl:when test="ns1:RegisteredSentInfo/tp:SentStatus = '3'">
                        <span data-phrase-id="sentSentStatus3"></span>
                      </xsl:when>
                      <xsl:when test="ns1:RegisteredSentInfo/tp:SentStatus = '4'">
                        <span data-phrase-id="sentSentStatus4"></span>
                      </xsl:when>
                      <xsl:when test="ns1:RegisteredSentInfo/tp:SentStatus = '5'">
                        <span data-phrase-id="sentSentStatus5"></span>
                      </xsl:when>
                    </xsl:choose>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTypeOfTransport"></span>
                    <xsl:choose>
                      <xsl:when test="ns1:RegisteredSentInfo/tp:TypeOfTransport = '1'">
                        <span data-phrase-id="sentTypeOfTransport1"></span>
                      </xsl:when>
                      <xsl:when test="ns1:RegisteredSentInfo/tp:TypeOfTransport = '2'">
                        <span data-phrase-id="sentTypeOfTransport2"></span>
                      </xsl:when>
                    </xsl:choose>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentGoodsSenderInfo"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-2" data-phrase-id="sentBasicInfo"></span>
                  </p>
                  <xsl:if test="ns1:GoodsSender/tp:TraderInfo/tp:IdSisc !=''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentIdSisc"></span>
                      <xsl:value-of select="ns1:GoodsSender/tp:TraderInfo/tp:IdSisc"/>
                    </p>
                  </xsl:if>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderName"></span>
                    <xsl:value-of select="ns1:GoodsSender/tp:TraderInfo/tp:TraderName"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityType"></span>
                    <xsl:value-of select="ns1:GoodsSender/tp:TraderInfo/tp:TraderIdentityType"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityNumber"></span>
                    <xsl:value-of select="ns1:GoodsSender/tp:TraderInfo/tp:TraderIdentityNumber"/>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-2" data-phrase-id="sentAdress"></span>
                  </p>
                  <xsl:variable name="ulica">
                    <xsl:choose>
                      <xsl:when test="ns1:GoodsSender/tp:TraderAddress/tp:FlatNumber != ''">
                        <p>
                          <xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:FlatNumber"/>
                        </p>
                      </xsl:when>
                      <xsl:otherwise>
                        <p>
                          <xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:HouseNumber"/>
                        </p>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
                  <p>
                    <xsl:value-of select="$ulica"/>
                  </p>
                  <p>
                    <xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:PostalCode"/><xsl:text>&#160;</xsl:text>
                    <xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:City"/>
                    <xsl:if test="ns1:GoodsSender/tp:TraderAddress/tp:City != ''">,</xsl:if>
                    <xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsSender/tp:TraderAddress/tp:Country"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentGoodsRecipientInfo"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-2" data-phrase-id="sentBasicInfo"></span>
                  </p>
                  <xsl:if test="ns1:GoodsRecipient/tp:TraderInfo/tp:IdSisc !=''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentIdSisc"></span>
                      <xsl:value-of select="ns1:GoodsRecipient/tp:TraderInfo/tp:IdSisc"/>
                    </p>
                  </xsl:if>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderName"></span>
                    <xsl:value-of select="ns1:GoodsRecipient/tp:TraderInfo/tp:TraderName"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityType"></span>
                    <xsl:value-of select="ns1:GoodsRecipient/tp:TraderInfo/tp:TraderIdentityType"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityNumber"></span>
                    <xsl:value-of select="ns1:GoodsRecipient/tp:TraderInfo/tp:TraderIdentityNumber"/>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-2" data-phrase-id="sentAdress"></span>
                  </p>
                  <xsl:variable name="ulica">
                    <xsl:choose>
                      <xsl:when test="ns1:GoodsRecipient/tp:TraderAddress/tp:FlatNumber != ''">
                        <p>
                          <xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:FlatNumber"/>
                        </p>
                      </xsl:when>
                      <xsl:otherwise>
                        <p>
                          <xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:HouseNumber"/>
                        </p>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
                  <p>
                    <xsl:value-of select="$ulica"/>
                  </p>
                  <p>
                    <xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:PostalCode"/><xsl:text>&#160;</xsl:text>
                    <xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:City"/>
                    <xsl:if test="ns1:GoodsRecipient/tp:TraderAddress/tp:City != ''">,</xsl:if>
                    <xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:GoodsRecipient/tp:TraderAddress/tp:Country"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentGoodsInfo"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info3">
                  <p>
                    <span class="sent-xslt element-2" data-phrase-id="sentPlaceOfLoading"></span>
                  </p>
                  <xsl:variable name="ulica">
                    <xsl:choose>
                      <xsl:when test="ns1:Transport/tp:PlaceOfLoading/tp:FlatNumber != ''">
                        <p>
                          <xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:FlatNumber"/>
                        </p>
                      </xsl:when>
                      <xsl:otherwise>
                        <p>
                          <xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:Street"/><xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:HouseNumber"/>
                        </p>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
                  <p>
                    <xsl:value-of select="$ulica"/>
                  </p>

                  <p>
                    <xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:PostalCode"/><xsl:text>&#160;</xsl:text> <xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:City"/>,<xsl:text>&#160;</xsl:text><xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:Country"/>
                  </p>
                  <xsl:if test="ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC != ''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentProvince"></span>
                      <xsl:choose>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '02'">dolnośląskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '04'">kujawsko-pomorskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '06'">lubelskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '08'">lubuskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '10'">łódzkie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '12'">małopolskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '14'">mazowieckie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '16'">opolskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '18'">podkarpackie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '20'">podlaskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '22'">pomorskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '24'">śląskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '26'">świętokrzyskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '28'">warmińsko-mazurskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '30'">wielkopolskie</xsl:when>
                        <xsl:when test="substring(ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC, 1,2) = '32'">zachodniopomorskie</xsl:when>
                      </xsl:choose>
                    </p>
                  </xsl:if>
                </div>
                <div class="sent-xslt info3">
                  <xsl:if test="ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC != ''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentTercId"></span>
                      <xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:CodeTERC"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:Transport/tp:PlaceOfLoading/tp:CodeSIMC != ''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentSimcId"></span>
                      <xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:CodeSIMC"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:Transport/tp:PlaceOfLoading/tp:CodeULIC != ''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentUlicId"></span>
                      <xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:CodeULIC"/>
                    </p>
                  </xsl:if>
                </div>
                <div class="sent-xslt info3">
                  <xsl:if test="ns1:Transport/tp:PlaceOfLoading/tp:Latitude != ''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentLatitude"></span>
                      <xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:Latitude"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:Transport/tp:PlaceOfLoading/tp:Longitude != ''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentLongitude"></span>
                      <xsl:value-of select="ns1:Transport/tp:PlaceOfLoading/tp:Longitude"/>
                    </p>
                  </xsl:if>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <xsl:variable name="plannedStartCarriageDate">
                    <xsl:choose>
                      <xsl:when test="string-length(ns1:Transport/tp:PlannedStartCarriageDate) > 10">
                        <xsl:value-of select="substring-before(ns1:Transport/tp:PlannedStartCarriageDate, '+')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="ns1:Transport/tp:PlannedStartCarriageDate"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentPlannedStartCarriageDate"></span>
                    <xsl:value-of select="$plannedStartCarriageDate"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentCarriedGoodsInfo"></p>
              <div class="sent-xslt grupInfo">
                <table class="sent-xslt table">
                  <tr>
                    <td class="sent-xslt table-header" data-phrase-id="sentSingleElementNumber" style="width: 3%"></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentCodeEan" style='width: 9%'></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentGoodsName"></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentAmountOfGoods" style='width: 6%'></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentUnitOfMeasure" style='width: 5%'></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentMedicinalNumberOfPermit" style='width: 13%'></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentMedicinalNumberOfPermitAuthority" style='width: 13%'></td>
                  </tr>
                  <xsl:for-each select="ns1:GoodsInformation">
                    <tr>
                      <xsl:choose>
                        <xsl:when test="tp:ElementNumber !=''">
                          <td class="sent-xslt table-element"><xsl:value-of select="tp:ElementNumber"/>.
                          </td>
                        </xsl:when>
                        <xsl:otherwise>
                          <td class="sent-xslt table-element"><xsl:value-of select='position()'/>.
                          </td>
                        </xsl:otherwise>
                      </xsl:choose>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:CodeEanClassification"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:GoodsName"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:AmountOfGoods"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:UnitOfMeasure"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:NumberOfLicense"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:AuthorityName"/>
                      </td>
                    </tr>
                  </xsl:for-each>
                </table>
              </div>
            </div>
            <xsl:if test="ns1:Comments != ''">
              <div class="sent-xslt t1">
                <p class="sent-xslt grupName" data-phrase-id="sentAdditionalInfo"></p>
                <div class="sent-xslt t1">
                  <div class="sent-xslt grupInfo">
                    <p>
						<span class="sent-xslt element-1" data-phrase-id="sentComments"></span>
                      <xsl:value-of select="ns1:Comments"/>
                    </p>
                  </div>
                </div>
              </div>
            </xsl:if>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
